# python-logfmter Debian package

This repository contains the Debian package to use [python-logfmter](https://github.com/jteppinette/python-logfmter) in UCS 5.2.

This whole project is MIT licensed, as it contains files from the original author's project.

From the `python-logfmter` README:

Add [logfmt](https://www.brandur.org/logfmt) structured logging using the stdlib logging module and without changing a single log call.

## Update version

- Update `$VERSION` in `Makefile`
- Provide `python-logfmter-v${VERSION}.tar.gz.sha256` (e.g. via `make hash`)
- Update changelog (`dch -i`)
- Update `DEBIAN_RELEASE` and `DEBIAN_SCOPE` in `.gitlab-ci.yml`
- Commit and push changes
- Either build manually, or push a git tag, then the CI pipeline will build the package.

## Manual build

```
@omar repo_admin.py -G "https://git.knut.univention.de/univention/dev/libraries/python-logfmter.git" -p python-logfmter -b "main" -P . -s errata5.2-3 -r 5.2
@ladda build-package-ng -r 5.2 -s errata5.2-3 -p python-logfmter
```
